%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This work by EPFL STI IBI LBNI is licensed under 
% a Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
% Based on a work at http://lbni.epfl.ch/.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% Some settings
j                                                   = str2double(get(S.j, 'string')); % j = channel
jj                                                  = get(S.channelDisplaySelect, 'Value');
         min_peak_distance                          = str2double(get(S.min_peak_distance(j), 'string'));        
         ScaleBar                                   = str2double(get(S.scale_bar_length, 'string'));
         FontSize                                   = 14;  
         FontName                                   = 'Arial';                                                                                          % Font for images
         print_dpi                                  = 150;    
         amplitude_fract                            = 0.05;                                                                                             % Amplitude variability for fitting histogramed peaks to determine thresholds
         crop_fraction                              = 0.0;
         index                                      = 1;
         percent_search                             = [1 10 90 99];
         disp_percent                               = 1;
        
        if get(S.Calc_flatten_lim(j), 'value')     == 1
           min_spacing_stdev_temp                  = min_spacing_stdev(jj,1);
           max_spacing_stdev_temp                  = max_spacing_stdev(jj,1);
        else
            min_spacing_stdev_temp                 = str2double(get(S.min_spacing_stdev_user(j), 'string'));
            max_spacing_stdev_temp                 = str2double(get(S.max_spacing_stdev_user(j), 'string'));
        end
         channels_titles = ['Topo [nm]        ';...
                            'fastz [nm]       ';...
                            'T-B [mv]         ';...
                            'fastTB [mv]      ';...
                            'L-R [mV]         ';...
                            'Amplitude [mV]   ';...
                            'FastR [mV]       ';...
                            'Phase []        ';...
                            'LiaX [mV]        ';...
                            'LiaY [mV]        ';...
                            'bias [mV]        ';...
                            'x-direction [um] ';...
                            'y-direction [um] ';...
                            'Zeit [S]         ';...
                            'minmax [A]       '];
        channel_info_Units = [  '[nm]   ';...
                                '[nm]   ';...
                                '[mv]   ';...
                                '[mv]   ';...
                                '[mV]   ';...
                                '[mV]   ';...
                                '[mV]   ';...
                                '[]    ';...
                                '[mV]   ';...
                                '[mV]   ';...
                                '[mV]   ';...
                                '[um]   ';...
                                '[um]   ';...
                                '[S]    ';
                                '[A]    '];
        
        peaks_fit                                   = get(S.peaks_fit(j), 'value')-1;
        image_to_plot                               = get(S.image_to_plot, 'string');
        
        if max(max(images(:, :, j))) == 0 && min(min(images(:, :, j))) == 0 % => the program failed at this point and the image was set to zero
            fit_hist = 0;
        else
            fit_hist = 1;
        end
    
       
%% Applies an offset to the whole image to put the reference peak at a given height reference_height
minimum_z                                                   = str2double(get(S.min_z(j), 'string'));
maximum_z                                                   = str2double(get(S.max_z(j), 'string'));
ScanZ                                                       = maximum_z-minimum_z;  
image_inside_range                                          = images(:,:,j);

%min_peak_distance                                           = ceil(histogram_bins*min_peak_distance/(max(max(image_inside_range))-min(min(image_inside_range))));

[height position]                                           = hist(reshape(image_inside_range(:,:),size(image_inside_range,1)*size(image_inside_range,2),1),histogram_bins);          % Calculates the histogram of the corrected height data (First image only)
[~, peak_index]                                             = findpeaks(smooth(height,smoothing_level,'loess'),'Sortstr','descend');                                         % Finds peaks in the corrected image to identify different terrace

peak_index                                                  = sort(peak_index(1:min([3, peaks_fit, length(peak_index)])),'ascend');       % Sorts peaks from smallest index (position) to highest one
peak_height                                                 = height(peak_index);

if fit_hist == 1
            t_hist_lower                                = zeros(1,3*min(3,length(peak_height))); 
            t_hist_start                                = zeros(1,3*min(3,length(peak_height))); 
            t_hist_upper                                = zeros(1,3*min(3,length(peak_height))); 
       for i                                            = 0:min(3,length(peak_height))-1                                                                                                    % Loops for the minimum of the number of peaks or 3
            t_hist_lower(3*i+1)                         = (1-amplitude_fract)*peak_height(i+1);
            t_hist_lower(3*i+2)                         = position(peak_index(i+1))-min_peak_distance/2;
            t_hist_lower(3*i+3)                         = min_spacing_stdev_temp;
            
            t_hist_upper(3*i+1)                         = (1+amplitude_fract)*peak_height(i+1);
            t_hist_upper(3*i+2)                         = position(peak_index(i+1))+min_peak_distance/2;
            t_hist_upper(3*i+3)                         = max_spacing_stdev_temp;
            
            t_hist_start(3*i+1)                         = (1-0)*peak_height(i+1);
            t_hist_start(3*i+2)                         = position(peak_index(i+1));
            t_hist_start(3*i+3)                         = (min_spacing_stdev_temp+max_spacing_stdev_temp)/2;
            
       end
        clear peak_gaussian_std peak_gaussian_ampl peak_gaussian_pos;
        % Fits the data with the speficied conditions
        t_hist = fitoptions('Method','NonlinearLeastSquares',...                                                                                                                        % Sets the conditions for fitting
                   'Lower',      t_hist_lower,...
                   'Upper',      t_hist_upper,...
                   'Startpoint', t_hist_start,...
                   'MaxIter',    1e2,...
                   'MaxFunEvals',3e2);
        %f_Number_hist = fittype(func_form,  'options' ,t_hist)
        func_form                                   = ['gauss',num2str(min(3,length(peak_height)))];
        f_Number_hist                               = fittype(func_form);
        [peak_hist_gaussian,peak_hist_gaussian_gof]           = fit(  position',...
                                                            smooth(height,smoothing_level,'loess'),...
                                                            f_Number_hist,t_hist);
    

% Combines all the amplitudes, the positions and the standard
% deviations into one vector and sets the lower and upper threshold
% for all peaks
peak_hist_gaussian_ampl                                     = [];
peak_hist_gaussian_pos                                      = [];
peak_hist_gaussian_std                                      = [];
for i = 1:length(peak_height)
eval(['peak_hist_gaussian_ampl(', num2str(i), ')= peak_hist_gaussian.a', num2str(i), ';']);
eval(['peak_hist_gaussian_pos(', num2str(i), ')= peak_hist_gaussian.b', num2str(i), ';']);
eval(['peak_hist_gaussian_std(', num2str(i), ')= peak_hist_gaussian.c', num2str(i), ';']);
end

[peak_hist_pos, ind]                                        = sort(peak_hist_gaussian_pos, 'ascend');
peak_hist_ampl                                              = zeros(size(peak_hist_pos));
for i                                                       = 1:length(peak_hist_pos)
    peak_hist_ampl(i)                                       = peak_hist_gaussian_ampl(ind(i));
end

if length(peak_hist_pos) >= (get(S.peak_reference_height(j), 'value')-1)
    eval(['peak_hist_gaussian_x_ref = peak_hist_pos(', num2str((get(S.peak_reference_height(j), 'value')-1)), ');']); 
elseif (get(S.peak_reference_height(j), 'value')-1) > 1 && length(peak_height_hist) >= (get(S.peak_reference_height(j), 'value')-1)-1
    eval(['peak_hist_gaussian_x_ref = peak_hist_pos(', num2str((get(S.peak_reference_height(j), 'value')-1)-1), ');']);
else
    peak_hist_gaussian_x_ref                                = peak_hist_pos(1);
end
%images(:,:,j)                                               = images(:,:,j) + str2double(get(S.z_height_reference(j), 'string')) - peak_hist_gaussian_x_ref;                           % Sets first peak to reference height                                                                                         % Adds the user selected Z-offset

end
            

%% --- Plot a nice image in GUI --- %    

    axes(S.ax1)
        
        imshow(imresize(images(:,:,j),[max(size(images(:,:,j))),max(size(images(:,:,j)))]),[minimum_z,maximum_z])                                      % Generates a new Figure with the name of the correct channel,  Resizes the image to a square the size of the largest dimension.  This is useful when using nonsquare pixels.  Sets the display range from the min to the max

     
        color_string    = get(S.ColorBarSelect, 'string');
        color_value     = get(S.ColorBarSelect, 'value');
        switch color_string{color_value}                                                                                                                                                   
            case 'Autumn'                                                                                                                                                        
                colormap(autumn);
            case 'Bone'                                                                                                                                                        
                colormap(bone);
            case 'ColorCube'                                                                                                                                                        
                colormap(colorcube);
            case 'Cool'                                                                                                                                                        
                colormap(cool);
            case 'Copper'                                                                                                                                                        
                colormap(copper);
            case 'Flag'                                                                                                                                                        
                colormap(flag);
            case 'Gray'                                                                                                                                                        
                colormap(gray);
            case 'Hot'                                                                                                                                                        
                colormap(hot);
            case 'HSV'                                                                                                                                                        
                colormap(hsv);
            case 'Jet'                                                                                                                                                        
                colormap(jet);
            case 'Lines'                                                                                                                                                        
                colormap(lines);
            case 'Pink'                                                                                                                                                        
                colormap(pink);
            case 'Prism'                                                                                                                                                        
                colormap(prism);
            case 'Spring'                                                                                                                                                        
                colormap(spring);
            case 'Summer'                                                                                                                                                        
                colormap(summer);
            case 'Winter'                                                                                                                                                        
                colormap(winter);
            case 'Sky'
                load('Sky','mycmap_sky') 
                colormap(mycmap_sky);
        end
                                                                                                                                                            % Sets the colormap 

            hcb= colorbar('YTick',minimum_z:ScanZ/10:maximum_z,...
                          'YTickLabel',{            [num2str(minimum_z+0*ScanZ/10,'%0.2f'),' ', channel_info_Units(j,:)],...                                                                    % Inserts a color bar.  Sets the 1st tick with approriate labels
                                                    [num2str(minimum_z+1*ScanZ/10,'%0.2f'),' ', channel_info_Units(j,:)],...                                                                    % Sets the 2nd tick with approriate labels
                                                    [num2str(minimum_z+2*ScanZ/10,'%0.2f'),' ', channel_info_Units(j,:)],...                                                                    % Sets the 3rd tick with approriate labels
                                                    [num2str(minimum_z+3*ScanZ/10,'%0.2f'),' ', channel_info_Units(j,:)],...                                                                    % Sets the 4th tick with approriate labels
                                                    [num2str(minimum_z+4*ScanZ/10,'%0.2f'),' ', channel_info_Units(j,:)],...                                                                    % Sets the 5th tick with approriate labels
                                                    [num2str(minimum_z+5*ScanZ/10,'%0.2f'),' ', channel_info_Units(j,:)],...                                                                    % Sets the 6th tick with approriate labels
                                                    [num2str(minimum_z+6*ScanZ/10,'%0.2f'),' ', channel_info_Units(j,:)],...                                                                    % Sets the 7th tick with approriate labels
                                                    [num2str(minimum_z+7*ScanZ/10,'%0.2f'),' ', channel_info_Units(j,:)],... 
                                                    [num2str(minimum_z+8*ScanZ/10,'%0.2f'),' ', channel_info_Units(j,:)],...  
                                                    [num2str(minimum_z+9*ScanZ/10,'%0.2f'),' ', channel_info_Units(j,:)],...                                                                    % Sets the 8th tick with approriate labels
                                                    [num2str(minimum_z+10*ScanZ/10,'%0.2f'),' ', channel_info_Units(j,:)]},...                                                                  % Sets the 9th tick with approriate labels
                                                    'FontSize', FontSize, 'FontName', FontName);                                                                                            % Sets the font and size for the color bar
            set(hcb,'YTickMode','manual','FontSize', FontSize, 'FontName', FontName);                                                                                                       % Apply the font to the colorbar

disp_scale_bar      = get(S.disp_scale_bar, 'value');
if disp_scale_bar == 1
        %This plots the integral scale bar.  It works...  It's not all my code.
        DistFactor                                  = 0.05;                                                                                                                                 % Scalebar height
        Length                                      = ScaleBar;                                                                                                                             % User set scalebar length
        Pos                                         = [0.5*max(size(images(:,:,j))),0.95*max(size(images(:,:,j)))];                                                                         % positions scale bar
        Scale                                       = ScanSize/(size(images,2)*(1+crop_fraction));                                                                                                              % Image scale
        UnitsName                                   = ' nm';                                                                                                                                % Units for the scale bar
        NextPlot                                    = get(gca,'NextPlot');                                                                                                              
        
        hold on;

        XLim                                        = get(gca,'XLim');
        YLim                                        = get(gca,'YLim');
        Xdiff                                       = abs(diff(XLim));
        Ydiff                                       = abs(diff(YLim));

        LineX                                       = Pos(1) + 0.5.*Length./Scale.*[-1;+1];
        LineY                                       = Pos(2).*[+1;+1];
        DistXdir                                    = 0;
        DistYdir                                    = -1;


        %--- plot line ---
        plot(LineX,LineY,'w-','LineWidth',2);


        %--- plot text ---
        DistX                                       = DistXdir.*DistFactor.*Xdiff;
        DistY                                       = DistYdir.*DistFactor.*Ydiff;

        Htext                                       = text(Pos(1)+DistX,Pos(2)+DistY,sprintf('%5.1f %s',Length,UnitsName));
        set(Htext,'HorizontalAlignment','center','Color', 'w', 'FontSize', FontSize, 'FontName', FontName);
        set(gca,'XLim',XLim);
        set(gca,'YLim',YLim);
        set(gca,'NextPlot',NextPlot);
        set(gca, 'XTickMode', 'manual')
else
end
        hold off;      
%% ---Plot a nice histogram and cdf in GUI ---%

            axes(S.ax2)
            image_inside_range                                   = images(:,:,j);
            image_inside_range((images(:,:,j) < minimum_z))      = NaN;                                                                                                              
            image_inside_range((images(:,:,j) > maximum_z))      = NaN;
            
 
            [y1_data x_data]                                = hist(reshape(image_inside_range(:,:),size(images,1)*size(images,2),1),minimum_z:(maximum_z-minimum_z)/(histogram_bins-1):maximum_z);
            y2_data                                         = zeros(size(y1_data,1),1);

            x_data                                          = x_data';
            y1_data                                         = y1_data';
            y1_data                                         = 100*y1_data/sum(y1_data);
            for i                                           = 1:size(y1_data,1)
                y2_data(i,1)                                = sum(y1_data(1:i));
            end

                [AX,H1,H2]                                  = plotyy(x_data,y1_data,x_data,y2_data,'plot');
                set(AX(1),'YColor','k');
                set(AX(2),'YColor','r');
                axis auto;
                
                 hold on;

                set(AX(1),'YLim',[-0.002*ceil(max(y1_data)) 1.002*ceil(max(y1_data))],'YTick',0:ceil(max(y1_data))/10:ceil(max(y1_data)),'YTickLabel',0:ceil(max(y1_data))/10:ceil(max(y1_data)))
                set(AX(2),'YLim',[-0.2 100.2],'YTick',0:10:100,'YTickLabel',0:10:100) 
                    axis_lim = [minimum_z,maximum_z];
                    set(AX(1),'XLim',axis_lim(1:2),'XTick',axis_lim(1):(axis_lim(2)-axis_lim(1))/10:axis_lim(2),'XTickLabel',axis_lim(1):(axis_lim(2)-axis_lim(1))/10:axis_lim(2));
                    set(AX(2),'XLim',axis_lim(1:2),'XTick',axis_lim(1):(axis_lim(2)-axis_lim(1))/10:axis_lim(2),'XTickLabel',axis_lim(1):(axis_lim(2)-axis_lim(1))/10:axis_lim(2));

                set(AX(1),'yticklabel',sprintf('%0.1f |',get(AX(1),'ytick')'));
                set(AX(2),'yticklabel',sprintf('%0.0f |',get(AX(2),'ytick')'));
                set(get(AX(1),'Ylabel'),'String','% Area','FontSize', FontSize, 'FontName', FontName,'Color','k');
                set(get(AX(2),'Ylabel'),'String','% Below Given Value','FontSize', FontSize, 'FontName', FontName,'Color','r');

                set(H1,'Color','k','LineWidth',2);
                set(H2,'Color','r','LineWidth',2);

                xlabel(channels_titles(j,:),'FontSize', FontSize, 'FontName', FontName );
                %title([channel_info(j).Name,'(',num2str(j),')',' ',num2str(file_number)],'FontSize', FontSize*1.5, 'FontName', FontName ); 
                set(AX(1),'FontSize', FontSize, 'FontName', FontName);
                set(AX(2),'FontSize', FontSize, 'FontName', FontName);

                if disp_percent == 1
                    percent_val                                     = zeros(length(percent_search),1);
                    text_disp                                       =  cell(length(percent_search),1);
                    for i                                           = 1:length(percent_search)
                        index_height                                = find(y2_data >= percent_search(i),1);
                        percent_val(i)                              = x_data(index_height);
                        text_disp{i,1}                              = [num2str(percent_search(i)),'% below ',num2str(percent_val(i),'%02.2f'),' ',channel_info_Units(j,:)];
                    end
                    x_range                                         = get(AX(1),'XLim'); 
                    y_range                                         = get(AX(1),'YLim');
                    text(x_range(2) -.02*(x_range(2)-x_range(1)),y_range(2)-.02*(y_range(2)-y_range(1)),text_disp,'FontSize', 0.75*FontSize, 'FontName', FontName,'VerticalAlignment','top','HorizontalAlignment','right' );
                else
                end

        if fit_hist == 1
            min_peak_dist_test                          = max([1,ceil(min_peak_distance/mean(diff(x_data)))]);
            min_peak_dist_test                          = min([255,min_peak_dist_test]);
            [peak_height peak_index]                    = findpeaks(smooth(y1_data,smoothing_level,'loess'),'MinpeakDistance', min_peak_dist_test, 'Sortstr','descend'); %min_peak_distance(jj), 'Threshold', peak_threshold, 'Sortstr','descend');                                                                       % Finds peaks in the corrected image to identify different terrace
            t_hist_lower                                = zeros(1,3*min(peaks_fit,length(peak_height))); 
            t_hist_start                                = zeros(1,3*min(peaks_fit,length(peak_height))); 
            t_hist_upper                                = zeros(1,3*min(peaks_fit,length(peak_height))); 
       for i                                            = 0:min(peaks_fit,length(peak_height))-1                                                                                                    % Loops for the minimum of the number of peaks or 3
            t_hist_lower(3*i+1)                         = (1-amplitude_fract)*peak_height(i+1);
            t_hist_lower(3*i+2)                         = x_data(peak_index(i+1))-min_peak_distance;
            t_hist_lower(3*i+3)                         = min_spacing_stdev_temp;
            
            t_hist_upper(3*i+1)                         = (1+amplitude_fract)*peak_height(i+1);
            t_hist_upper(3*i+2)                         = x_data(peak_index(i+1))+min_peak_distance/2;
            t_hist_upper(3*i+3)                         = max_spacing_stdev_temp;
            
            t_hist_start(3*i+1)                         = (1-0)*peak_height(i+1);
            t_hist_start(3*i+2)                         = x_data(peak_index(i+1));
            t_hist_start(3*i+3)                         = (min_spacing_stdev_temp+max_spacing_stdev_temp)/2;
            
       end
        clear peak_gaussian_std peak_gaussian_ampl peak_gaussian_pos;
        % Fits the data with the speficied conditions
        t_hist = fitoptions('Method','NonlinearLeastSquares',...                                                                                                                        % Sets the conditions for fitting
                   'Lower',      t_hist_lower,...
                   'Upper',      t_hist_upper,...
                   'Startpoint', t_hist_start,...
                   'MaxIter',    1e2,...
                   'MaxFunEvals',3e2);
        %f_Number_hist = fittype(func_form,  'options' ,t_hist)
        func_form                                   = ['gauss',num2str(min(peaks_fit,length(peak_height)))];
        f_Number_hist                               = fittype(func_form);
        [peak_hist_gaussian,peak_hist_gaussian_gof]           = fit(    x_data,...
                                                                        y1_data,...
                                                                        f_Number_hist,t_hist);
                

% disp('Fitted GOF')
% disp(peak_hist_gaussian_gof)
            plot(x_data,peak_hist_gaussian(x_data),'--b','LineWidth',2);

            for i                                           = 1:min(peaks_fit,length(peak_height))
            text(1.05*eval(['peak_hist_gaussian.b',num2str(i)]),...
             0.85*eval(['peak_hist_gaussian.a',num2str(i)]),...
             { [num2str(sum(eval(['peak_hist_gaussian.a',num2str(i),'*exp(-(x_data-peak_hist_gaussian.b',num2str(i),').^2/((peak_hist_gaussian.c',num2str(i),')^2))'])),'%02.2f'),'% @'];...
               [num2str(eval(['peak_hist_gaussian.b',num2str(i)]),'%02.2f'),' +- ',num2str(eval(['1/sqrt(2)*peak_hist_gaussian.c',num2str(i)]),'%02.2f'),' ',channel_info_Units(j,:)]},...
             'FontSize', 0.75*FontSize, 'FontName', FontName,'VerticalAlignment','bottom','HorizontalAlignment','left','color','b' );
            end
            
        else
        end

            hold off; 
        
        %end
        
        
